package com.clx.performance.model.linewarn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 线路预警信息表
* @Date: 2024/05/30 13:30:04
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class LineWarnInfo implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer warnConfigId;                   //预警配置id
    private String warnName;                        //预警名称
    private Integer warnType;                       //预警类型
    private Integer warnLevel;                      //预警级别
    private String orderGoodsNo;                    //货单编号
    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private LocalDateTime suspendTime;              //预警暂停时间
    private String weather;                         //天气
    private LocalDateTime warnTime;                 //预警时间
    private Integer status;                         //处理状态：1待处理 2已处理 3暂停预警
    private String createBy;                        //创建人
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}