package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-07-18
 * Time 17:04
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_goods_adjustment_price")
public class OrderGoodsAdjustmentPrice implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("order_goods_no")
    @ApiModelProperty("货单编码")
    private String orderGoodsNo;

    @TableField("pre_amount")
    @ApiModelProperty("上次金额  ")
    private BigDecimal preAmount;

    @TableField("amount")
    @ApiModelProperty("本次调价金额")
    private BigDecimal amount;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
