package com.clx.performance.esplus.model;

import lombok.Data;
import org.dromara.easyes.annotation.IndexField;
import org.dromara.easyes.annotation.IndexId;
import org.dromara.easyes.annotation.IndexName;
import org.dromara.easyes.annotation.rely.FieldType;
import org.dromara.easyes.annotation.rely.IdType;

import java.math.BigDecimal;

@Data
@IndexName(value = "clx_truck_latest_pos")
public class TruckLatestPosESPlus {

    @IndexId(type= IdType.UUID)
    private String id;
    @IndexField(fieldType = FieldType.KEYWORD)
    private String truckNo;         //车辆编号
    private BigDecimal angle;       //agl
    private BigDecimal speed;       //速度
    private BigDecimal mileage;     //里程
    private BigDecimal height;      //海拔
    private BigDecimal[] location;  //位置
    @IndexField(fieldType = FieldType.DATE)
    private String gpsTime;         //时间
    private String createTime;

}