package com.clx.performance.enums;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by cuiwanzhe on 2017/6/2.
 * 支付备注枚举
 */
public enum PayRemarkEnum {
    OWNER_CREDIT(1, "货主冻结押金"),
    DRIVER_CREDIT(2, "司机冻结押金"),
    OWNER_FREIGHT(3, "货主冻结运费"),
    OWNER_INSURANCE(4, "货主冻结保险"),
    DRIVER_UNFREEZE(5, "司机解冻押金"),
    INSURANCE_UNFREEZE(6, "解冻保险到系统账户"),
    COMPENSATION_TO_DRIVER(7, "司机赔偿货主"),
    FREIGHT_TO_OWNER(8, "货主支付运费给司机"),
    UPDATE_FREIGHT(9, "修正运费"),
    UPDATE_INSURANCE(10, "修正保险"),
    OWNER_UNFREEZE(11, "解冻货主的押金"),
    DRIVER_SALE(12, "冻结司机的消费"),
    DRIVER_SALE_UNFREEZE(13, "司机支付货款给货主"),
    //v78 解冻保险
    UNFREEZE_INSURANCE(14, "解冻保险"),
    //v78 解冻保险
    OWNER_PAY_DRIVER_INSURANCE(15, "货主取消订单赔偿金"),
    DRIVER_PAY_OWNER_DRIVER_INSURANCE(16, "司机取消订单赔偿金"),
    UPDATE_DRIVER_FREEZE(17, "修正司机押金"),

    ;

    private static Map<Integer, String> map = new ConcurrentHashMap<>();
    static {
        for(PayRemarkEnum payRemarkEnum : PayRemarkEnum.values()){
            map.put(payRemarkEnum.getValue(), payRemarkEnum.getDisplayValue());
        }
    }
    private int value;
    private String displayValue;

    public void setValue(int value) {
        this.value = value;
    }

    public String getDisplayValue() {
        return displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    private PayRemarkEnum(int value, String displayValue){
        this.value = value;
        this.displayValue = displayValue;
    }
    public int getValue(){
        return value;
    }
    public static String toString(int value){
        return map.get(value);
    }
}
