package com.clx.performance.dao.loan;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.loan.BorrowerConfigMapper;
import com.clx.performance.model.loan.BorrowerConfig;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerConfigParam;
import com.clx.performance.vo.pc.loan.carrier.BorrowerConfigVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 借款配置
 * @Date: 2024/01/17 13:42:57
 * @Version: 1.0
 */
public interface BorrowerConfigDao extends BaseDao<BorrowerConfigMapper, BorrowerConfig, Integer> {

    boolean update(BorrowerConfig item);
    boolean updateStatus(BorrowerConfig item);
    boolean updateDelete(BorrowerConfig item);
    boolean updateName(Integer borrowerId, String borrowerName);

    Optional<BorrowerConfig> selectByBorrowerIdAndType(Integer borrowerId, Integer type);

    List<BorrowerConfig> listEnable();

    IPage<BorrowerConfigVO> pageByParam(PageBorrowerConfigParam param);
}
