package com.clx.performance.controller.temp;

import com.clx.order.vo.feign.FeignAddressVO;
import com.clx.performance.extranal.user.AddressService;
import com.clx.performance.service.linewarn.LineWarnMqHandlerService;
import com.clx.performance.service.linewarn.LineWarnMqService;
import com.clx.performance.utils.gd.GdUtils;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/lineWarn")
public class TempLineWarnController {

    @Autowired
    private LineWarnMqService lineWarnMqService;
    @Autowired
    private AddressService addressService;
    @Autowired
    private GdUtils gdUtils;
    @Autowired
    private LineWarnMqHandlerService lineWarnMqHandlerService;

    @ApiOperation(value = "test", notes = "<br>By:艾庆国")
    @PostMapping("/test")
    public Result test() {

        return Result.ok();
    }

    @ApiOperation(value = "运单异常", notes = "<br>By:艾庆国")
    @PostMapping("/orderChildWarn")
    public Result orderChildWarn(String orderGoodsNo, String childNo) {

        lineWarnMqService.orderChildWarn(orderGoodsNo, childNo);
        return Result.ok();
    }

    @ApiOperation(value = "货单新增", notes = "<br>By:艾庆国")
    @PostMapping("/orderGoodsAdd")
    public Result orderGoodsAdd(String orderGoodsNo) {

        lineWarnMqService.orderGoodsAdd(orderGoodsNo);
        return Result.ok();
    }
    @ApiOperation(value = "天气", notes = "<br>By:艾庆国")
    @PostMapping("/weather")
    public Result<Map<String, String>> weather(Integer sendAddressId, Integer receiveAddressId) {
        Map<String, String> result = new HashMap<>();

        Optional<FeignAddressVO> addressOptional = addressService
                .getSendAndReceiveAddress(sendAddressId, receiveAddressId);
        if (addressOptional.isEmpty()) {return Result.ok(result);}
        FeignAddressVO feignAddressVO = addressOptional.get();


        if (feignAddressVO.getSendAddress()!=null){
            String cityCode = gdUtils.getCity(feignAddressVO.getSendAddress().getLongitude(),
                    feignAddressVO.getSendAddress().getLatitude());

            String weather = gdUtils.getWeather(cityCode);
            result.put("send", weather);
        }

        if (feignAddressVO.getReceiveAddress()!=null){
            String cityCode = gdUtils.getCity(feignAddressVO.getReceiveAddress().getLongitude(),
                    feignAddressVO.getReceiveAddress().getLatitude());
            String weather = gdUtils.getWeather(cityCode);
            result.put("receive", weather);

        }

        return Result.ok(result);
    }

    @ApiOperation(value = "发送预警短信", notes = "<br>By:艾庆国")
    @PostMapping("/sendSms")
    public Result sendSms(String mobile, String warnName, String orderGoodsNo) {

        lineWarnMqHandlerService.sendSms(Arrays.asList(mobile), warnName, orderGoodsNo);

        return Result.ok();
    }

    @ApiOperation(value = "发送预警外呼", notes = "<br>By:艾庆国")
    @PostMapping("/sendClink")
    public Result sendClink(String mobile, String warnName, String orderGoodsNo) {
        lineWarnMqHandlerService.sendClink(Arrays.asList(mobile), warnName, orderGoodsNo);

        return Result.ok();
    }

}
