package com.clx.performance.controller.pc.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnRangeParam;
import com.clx.performance.param.pc.vehiclewarn.VehicleWarnRangeResumeUpdateParam;
import com.clx.performance.param.pc.vehiclewarn.VehicleWarnRangeSuspendUpdateParam;
import com.clx.performance.service.vehiclewarn.VehicleWarnRangeService;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnRangDTO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@Validated
@Api(tags = "车辆预警-预警暂停管理")
@RequestMapping(value="/pc/owner/vehicleWarnRange")
public class VehicleWarnRangeController {

    @Autowired
    private VehicleWarnRangeService vehicleWarnRangeService;

    @ApiOperation(value = "更新预警暂停", notes = "<br>By:艾庆国")
    @PostMapping("/updateSuspend")
    public Result<Void> updateSuspend(@RequestBody @Validated VehicleWarnRangeSuspendUpdateParam param) {
        vehicleWarnRangeService.updateSuspend(param);
        return Result.ok();
    }

    @ApiOperation(value = "更新预警解除", notes = "<br>By:艾庆国")
    @PostMapping("/updateResume")
    public Result<Void> updateResume(@RequestBody @Validated VehicleWarnRangeResumeUpdateParam param) {
        vehicleWarnRangeService.updateResume(param);
        return Result.ok();
    }

    @ApiOperation(value = "获取暂停信息",notes = "<br>By:艾庆国")
    @GetMapping("/getRange")
    public Result<VehicleWarnRangDTO> getRange(@NotNull(message = "id不能为空") @Validated Integer id) {
        return Result.ok(vehicleWarnRangeService.getRange(id));
    }

    @ApiOperation(value = "分页搜索预警暂停列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageRange")
    public Result<PageData<VehicleWarnRangDTO>> pageRange(@RequestBody @Validated PageVehicleWarnRangeParam param) {
        IPage<VehicleWarnRangDTO> page = vehicleWarnRangeService.pageRange(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
