package com.clx.performance.controller.pc.integral;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.param.pc.integral.*;
import com.clx.performance.service.integral.IntegralTruckRuleService;
import com.clx.performance.vo.pc.integral.AppIntegralTruckRuleVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral/truck/rule")
@Validated
@Api(tags = "承运端-车辆规则")
@AllArgsConstructor
public class IntegralTruckRuleController {

    @Autowired
    private IntegralTruckRuleService integralTruckRuleService;


    @ApiOperation(value = "新增车辆层级配置", notes = "<br>By:艾庆国")
    @PostMapping(value = "addRule")
    @UnitCovert
    public Result<Void> addRule(@RequestBody @Validated IntegralTruckRuleSaveParam param) {
        if (param.getIntegralRatioBegin() == null && param.getIntegralRatioEnd()==null){
            throw new ServiceSystemException(PerformanceResultEnum.INTEGRAL_RULE_RATIO_ALL_EMPTY);
        }

        integralTruckRuleService.addRule(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新车辆层级配置", notes = "<br>By:艾庆国")
    @PostMapping("/updateRule")
    @UnitCovert
    public Result<Void> updateRule(@RequestBody @Validated IntegralTruckRuleUpdateParam param) {
        integralTruckRuleService.updateRule(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新车辆层级配置状态", notes = "<br>By:艾庆国")
    @PostMapping("/updateRuleStatus")
    public Result<Void> updateRuleStatus(@RequestBody @Validated IntegralTruckRuleStatusUpdateParam param) {
        integralTruckRuleService.updateRuleStatus(param);

        return Result.ok();
    }

    @ApiOperation(value = "删除车辆层级配置", notes = "<br>By:艾庆国")
    @PostMapping("/deleteRule")
    public Result<Void> deleteRule(@RequestBody @Validated IntegralTruckRuleStatusDeleteParam param) {
        integralTruckRuleService.deleteRule(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询车辆层级配置信息", notes = "<br>By:艾庆国")
    @GetMapping(value = "getRuleInfo")
    @UnitCovert(param = false)
    public Result<AppIntegralTruckRuleVO> getRuleInfo(@Validated @NotNull(message = "id不能为空") Integer id) {

        return Result.ok(integralTruckRuleService.getRuleInfo(id));
    }

    @ApiOperation(value = "分页查询车辆层级配置列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageRule")
    @UnitCovert(param = false)
    public Result<PageData<AppIntegralTruckRuleVO>> pageRule(@RequestBody @Validated PageIntegralTruckRuleParam param) {
        IPage<AppIntegralTruckRuleVO> page = integralTruckRuleService.pageRule(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
