package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.PagePlatformAccountConfigParam;
import com.clx.performance.param.pc.carrier.SavePlatformAccountConfigParam;
import com.clx.performance.service.PlatformAccountConfigService;
import com.clx.performance.vo.pc.carrier.settle.*;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/platformAccountConfig")
@Validated
@Api(tags = "承运端-平台账户配置")
@AllArgsConstructor
public class PlatformAccountConfigController {

    private final PlatformAccountConfigService platformAccountConfigService;

    @ApiOperation(value = "平台账户配置列表",notes = "<br>By:姜文业")
    @PostMapping("/pagePlatformAccountConfig")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPagePlatformAccountConfigVO>> pagePlatformAccountConfig(@RequestBody @Validated PagePlatformAccountConfigParam param) {
        IPage<CarrierPagePlatformAccountConfigVO> page = platformAccountConfigService.pagePlatformAccountConfig(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "平台账户配置详情",notes = "<br>By:姜文业")
    @GetMapping("/getPlatformAccountConfigDetail")
    @UnitCovert(param = false)
    public Result<CarrierPagePlatformAccountConfigVO> getPlatformAccountConfigDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(platformAccountConfigService.getPlatformAccountConfigDetail(id));
    }

    @ApiOperation(value = "删除平台账户配置",notes = "<br>By:姜文业")
    @GetMapping("/deletePlatformAccountConfig")
    @UnitCovert(param = false)
    public Result<CarrierPagePlatformAccountConfigVO> deletePlatformAccountConfig(@NotNull(message = "id不能为空") Integer id) {
        platformAccountConfigService.deletePlatformAccountConfig(id);
        return Result.ok();
    }

    @ApiOperation(value = "新增平台账户配置",notes = "<br>By:姜文业")
    @PostMapping("/savePlatformAccountConfig")
    public Result savePlatformAccountConfig(@RequestBody @Validated SavePlatformAccountConfigParam param) {
        platformAccountConfigService.savePlatformAccountConfig(param);
        return Result.ok();
    }

    @ApiOperation(value = "编辑平台账户配置",notes = "<br>By:姜文业")
    @PostMapping("/updatePlatformAccountConfig")
    public Result updatePlatformAccountConfig(@RequestBody @Validated SavePlatformAccountConfigParam param) {
        platformAccountConfigService.updatePlatformAccountConfig(param);
        return Result.ok();
    }

}
