package com.clx.performance.controller.app;

import com.clx.performance.service.DictionaryService;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;

@Slf4j
@RestController
@RequestMapping(value="/app/dictionary")
@Validated
@Api(tags = "承运司机端-字典")
@AllArgsConstructor
public class AppDictionaryController {

    private final DictionaryService dictionaryService;


    @ApiOperation(value = "字典",notes = "<br>By:李瑞新")
    @GetMapping("/getOneByKey")
    public Result<String> getOneByKey(@NotBlank(message = "key不能为空") String key) {
        return Result.ok(dictionaryService.getOneByKey(key));
    }

}
