package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 轨迹-mq
 * @Date: 2023-10-19 15:10:10
 * @Version: 1.0
 */
public class RabbitKeyTraceConstants {

    private static final String PREFIX = "clx-performance.trace.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeyTraceConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 车辆轨迹同步
     */
    public static final String TRUCK_TRACE_SYNC_QUEUE = PREFIX +"truck.trace.update"+QUEUE;
    public static final String TRUCK_TRACE_SYNC_ROUTING_KEY = PREFIX +"truck.trace.update"+QUEUE_ROUTING_KEY;

}
