package com.clx.performance.constant;

/**
 * @Author: aiqingguo
 * @Description: 结算-mq
 * @Date: 2023-10-19 15:13:06
 * @Version: 1.0
 */
public class RabbitKeySettlementConstants {

    private static final String PREFIX = "clx-performance.settlement.";
    private static final String EXCHANGE = ".exchange";
    private static final String QUEUE = ".queue";
    private static final String QUEUE_ROUTING_KEY = ".routing.key";
    private static final String DELAY_QUEUE = ".delay.queue";
    private static final String DELAY_ROUTING_KEY = ".delay.routing.key";
    private static final String DEAD_QUEUE = ".dead.queue";
    private static final String DEAD_ROUTING_KEY = ".dead.routing.key";

    private RabbitKeySettlementConstants() {
    }

    /**
     * 缺省交换机
     */
    public static final String DEFAULT_EXCHANGE = PREFIX +"default"+EXCHANGE;

    /**
     * 缺省延迟队列
     */
    public static final String DEFAULT_DELAY_QUEUE = PREFIX +"default"+DELAY_QUEUE;
    public static final String DEFAULT_DELAY_ROUTING_KEY = PREFIX +"default"+DELAY_ROUTING_KEY;
    public static final String DEFAULT_DEAD_QUEUE = PREFIX +"default"+DEAD_QUEUE;
    public static final String DEFAULT_DEAD_ROUTING_KEY = PREFIX +"default"+DEAD_ROUTING_KEY;

    /**
     * 新增计费单
     */
    public static final String SETTLEMENT_DETAIL_ADD_QUEUE = PREFIX +"settlementDetail.add"+QUEUE;
    public static final String SETTLEMENT_DETAIL_ADD_ROUTING_KEY = PREFIX +"settlementDetail.add"+QUEUE_ROUTING_KEY;

    /**
     * 计费统计
     */
    public static final String SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_QUEUE = PREFIX +"settlementDetailInvoiceType.sync"+QUEUE;
    public static final String SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_ROUTING_KEY = PREFIX +"settlementDetailInvoiceType.sync"+QUEUE_ROUTING_KEY;

    /**
     * 同步开票标识
     */
    public static final String SETTLEMENT_INVOICE_TYPE_SYNC_QUEUE = PREFIX +"settlementInvoiceType.sync"+QUEUE;
    public static final String SETTLEMENT_INVOICE_TYPE_SYNC_ROUTING_KEY = PREFIX +"settlementInvoiceType.sync"+QUEUE_ROUTING_KEY;

    /**
     * 结算
     */
    public static final String SETTLEMENT_SETTLE_QUEUE = PREFIX +"settlement.settle"+QUEUE;
    public static final String SETTLEMENT_SETTLE_ROUTING_KEY = PREFIX +"settlement.settle"+QUEUE_ROUTING_KEY;
    /**
     * 开票状态同步
     */
    public static final String SETTLEMENT_INVOICE_STATUS_SYNC_QUEUE = PREFIX +"settlementInvoiceStatus.sync"+QUEUE;
    public static final String SETTLEMENT_INVOICE_STATUS_SYNC_ROUTING_KEY = PREFIX +"settlementInvoiceStatus.sync"+QUEUE_ROUTING_KEY;

    /**
     * 支付状态同步
     */
    public static final String SETTLEMENT_PAY_STATUS_SYNC_QUEUE = PREFIX +"settlementPayStatus.sync"+QUEUE;
    public static final String SETTLEMENT_PAY_STATUS_SYNC_ROUTING_KEY = PREFIX +"settlementPayStatus.sync"+QUEUE_ROUTING_KEY;

    /**
     * 风控处理
     */
    public static final String SETTLEMENT_RISK_PROCESS_QUEUE = PREFIX +"settlementRisk.process"+QUEUE;
    public static final String SETTLEMENT_RISK_PROCESS_ROUTING_KEY = PREFIX +"settlementRisk.process"+QUEUE_ROUTING_KEY;

    /**
     * 开票公司新增
     */
    public static final String SETTLEMENT_INVOICE_COMPANY_UPDATE_QUEUE = PREFIX +"settlementInvoiceCompany.update"+QUEUE;
    public static final String SETTLEMENT_INVOICE_COMPANY_UPDATE_ROUTING_KEY = PREFIX +"settlementInvoiceCompany.update"+QUEUE_ROUTING_KEY;

    /**
     * 平台自动确认
     */
    public static final String SETTLEMENT_PLATFORM_AUTO_CONFIRM_UPDATE_QUEUE = PREFIX +"settlementPlatformAutoConfirm.update"+QUEUE;
    public static final String SETTLEMENT_PLATFORM_AUTO_CONFIRM_UPDATE_ROUTING_KEY = PREFIX +"settlementPlatformAutoConfirm.update"+QUEUE_ROUTING_KEY;

}
