package com.clx.performance.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

import java.time.Duration;
import java.time.temporal.ChronoUnit;


@ConfigurationProperties(prefix = "spring.elasticsearch")
@Configuration
@Getter
@Setter
@RefreshScope
public class EsPoolProperties {
    /**
     * 连接存活时间
     */
    private Duration keepAlive = Duration.of(120, ChronoUnit.SECONDS);
    /**
     * 连接池最大连接数
     */
    private int maxTotal = 30;
    /**
     * 单节点最大连接数
     */
    private int maxPerRoute = 10;
}
