package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@NoArgsConstructor
public class OrderChildPoundAuditDetailVO {

    @ApiModelProperty(value="运单编号",example = "41441")
    private String childNo;

    @ApiModelProperty(value="装货净重",example = "10")
    private BigDecimal loadNet;

    @ApiModelProperty(value="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @ApiModelProperty(value = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @ApiModelProperty(value = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @ApiModelProperty(value="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @ApiModelProperty(value="卸货皮重",example = "41")
    private BigDecimal unloadTare;

    @ApiModelProperty(value = "卸货磅单编号", example = "url")
    private String unloadPoundNo;

    @ApiModelProperty(value="审核状态 0 待审核 1 审核通过 2 审核驳回",example = "1")
    private Integer status;

    @ApiModelProperty(value="备注",example = "41441")
    private String remark;

    @ApiModelProperty(value="审核驳回类型：1装车 2卸车 3装车+卸车",example = "1")
    private Integer rejectType;

    @ApiModelProperty(value="装车磅单图片")
    private List<String> loadImages;

    @ApiModelProperty(value="卸车磅单图片")
    private List<String> unloadImages;

    @ApiModelProperty(value="创建时间",example = "2012-01-01 01:10:10")
    private String createTime;

    @ApiModelProperty("车牌号")
    private String truckNo;

    @ApiModelProperty(value = "装车时间")
    private String loadTime;

    @ApiModelProperty(value = "卸车时间")
    private String unloadTime;

    @ApiModelProperty(value = "发货地址")
    private String sendAddress;

    @ApiModelProperty(value = "收货地址")
    private String receiveAddress;

    @ApiModelProperty(value = "装车识别毛重参考")
    private BigDecimal loadGrossWeight;

    @ApiModelProperty(value = "装车识别皮重参考")
    private BigDecimal loadTareWeight;

    @ApiModelProperty(value = "卸车识别毛重参考")
    private BigDecimal unloadGrossWeight;

    @ApiModelProperty(value = "卸车识别皮重参考")
    private BigDecimal unloadTareWeight;
}