package com.clx.performance.vo.mq;

import lombok.*;

import java.util.Arrays;
import java.util.Optional;

/**
 * @Author: aiqingguo
 * @Description: 结算统计
 * @Date: 2023-10-19 15:45:25
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class SettlementStatisticsMqParam {

    private String childNo;             //运单编号
    private Integer type;               //类型： 1统计 2拆单

    @Getter
    @AllArgsConstructor
    public enum Type {
        STATISTICS(1, "统计"),
        SEPARATE(2, "拆单"),

        ;

        private final Integer code;
        private final String msg;
        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getMsg).orElse(null);
        }
    }

}
