package com.clx.performance.param.temp;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class TruckTraceAddParam {

    @ApiModelProperty(value = "车辆轨迹列表")
    private List<TruckTraceItem> traceList;

    @Setter
    @Getter
    @ToString
    @NoArgsConstructor
    public static class TruckTraceItem{
        @ApiModelProperty(value = "车辆编号", example = "京A12345")
        private String truckNo;
        @ApiModelProperty(value = "正北方向夹角", example = "12.34")
        private BigDecimal angle;
        @ApiModelProperty(value = "速度", example = "12.34")
        private BigDecimal speed;
        @ApiModelProperty(value = "里程", example = "12.34")
        private BigDecimal mileage;
        @ApiModelProperty(value = "海拔", example = "12.34")
        private BigDecimal height;
        @ApiModelProperty(value = "位置 [123.45, 12.34]")
        private BigDecimal[] location;
        @ApiModelProperty(value = "时间")
        private String gpsTime;
    }

}
