package com.clx.performance.param.pc.owner;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class PageInvoiceOwnerSettlementOwnerDetailParam extends PageParam {

    @NotNull(message = "是否已开票不能为空")
    @ApiModelProperty(value = "是否已开票，0：否，1：是")
    private Integer invoiceStatus;

    @ApiModelProperty(value = "货主用户编号")
    private Long ownerUserNo;

    @ApiModelProperty(value = "货主名称")
    private String ownerName;

    @ApiModelProperty(value = "结算单编号")
    private String settlementNo;

    @ApiModelProperty(value="运单编号")
    private String childNo;

    @ApiModelProperty(value="开票公司")
    private String invoicingCompanyShorterName;

    @ApiModelProperty(value="开票标识：1网运单 2普通单")
    private Integer invoiceType;

    @ApiModelProperty(value = "开始时间")
    private String beginTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;
}
