package com.clx.performance.param.pc.owner;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @Author liruixin
 * @create 2023-09-19 13:33
 */
@Getter
@Setter
@NoArgsConstructor
@ToString
public class OwnerPaymentSettlementParam {

    @NotNull(message = "id不能为空")
    @ApiModelProperty(value="列表id",example = "10")
    private Integer id;

    @NotBlank(message = "收款人不能为空")
    @ApiModelProperty(value = "收款人", example = "收款人")
    private String payee;

    @NotBlank(message = "收款银行不能为空")
    @ApiModelProperty(value = "收款银行", example = "浙江银行")
    private String payeeBankName;

    @NotBlank(message = "收款银行卡卡号不能为空")
    @ApiModelProperty(value = "收款银行卡卡号", example = "62213545878787")
    private String payeeBankCardNo;

    @NotBlank(message = "付款银行不能为空")
    @ApiModelProperty(value = "付款银行", example = "浙江银行")
    private String paymentBankName;

    @NotBlank(message = "付款银行卡卡号不能为空")
    @ApiModelProperty(value = "付款银行卡卡号", example = "62213545878787")
    private String paymentBankCardNo;


    @NotBlank(message = "付款凭证不能为空")
    @ApiModelProperty(value = "付款凭证", example = "/a.png")
    private String paymentImg;

    @ApiModelProperty(value = "交易密码")
    private String accountPassword;
}
