package com.clx.performance.param.pc.carrier;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class CarrierSettlementOwnerDetailCompanyUpdateParam {

    @NotNull(message = "id列表不能为空")
    @ApiModelProperty(value="id列表")
    private List<Integer> idList;

    @NotNull(message = "开票公司id不能为空")
    @ApiModelProperty(value="开票公司id")
    private Integer companyId;

    @NotBlank(message = "开票公司简称不能为空")
    @ApiModelProperty(value="开票公司简称")
    private String companyShorterName;

    @NotBlank(message = "开票公司统一社会信用代码不能为空")
    @ApiModelProperty(value="开票公司统一社会信用代码")
    private String companyGroupCode;

}
