package com.clx.performance.param.pc;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.util.List;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class QueryOrderChildsListByParam extends PageParam {

    @ApiModelProperty(value = "运单状态集合")
    private List<Integer> statusList;

    @ApiModelProperty(value = "货单编号")
    @NotBlank(message = "货单编号不能为空")
    private String orderGoodsNo;

}
