package com.clx.performance.param.feign.transport;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

/**
 * 自然人货主同步
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class OwnerPersonalSyncParam {

    @ApiModelProperty(value = " 登陆手机号 ", required = true)
    @NotBlank(message = "货主登录手机号不可为空")
    private String mobile;
    @ApiModelProperty(value = " 货主姓名 ", required = true)
    @NotBlank(message = "货主姓名不可为空")
    private String name;
    @ApiModelProperty(value = " 身份证号 ", required = true)
    @NotBlank(message = "身份证号不可为空")
    private String cardNo;

    @ApiModelProperty(value = " 省 ", required = true)
    private String province;
    @ApiModelProperty(value = " 省code ", required = true)
    private Integer provinceCode;
    @ApiModelProperty(value = " 市 ", required = true)
    private String city;
    @ApiModelProperty(value = " 市code ", required = true)
    private Integer cityCode;
    @ApiModelProperty(value = " 区县 ", required = true)
    private String county;
    @ApiModelProperty(value = " 区县code ", required = true)
    private Integer countyCode;

//    @ApiModelProperty(value = " 乡镇 ", required = false)
//    private String town;
//    @ApiModelProperty(value = " 乡镇code ", required = false)
//    private Integer townCode;
//    @ApiModelProperty(value = " 街道 ", required = false)
//    private String street;
//    @ApiModelProperty(value = " 街道code ", required = false)
//    private Integer streetCode;

    @NotBlank(message = "详细地址不可为空")
    @ApiModelProperty(value = " 详细地址 ", required = true)
    private String address;

    @NotBlank(message = "身份证正面图片不可为空")
    @ApiModelProperty(value = " 身份证正面图片地址 ", required = true)
    private String legalFrontImg;
    @NotBlank(message = "身份证背面图片不可为空")
    @ApiModelProperty(value = " 身份证背面图片地址 ", required = true)
    private String legalBackImg;
    @ApiModelProperty(value = "手持身份证")
    private String personHandheldImg;

    @ApiModelProperty(value = " 个人邮箱 ")
    private String businessEmail;

}
