package com.clx.performance.param.feign;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;


@Getter
@Setter
public class CancelOrderGoodsParam {
    @NotBlank(message = "订单编号不能为空")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @NotNull(message = "操作人编号不能为空")
    @ApiModelProperty("操作人编号")
    private Long createBy;

    @NotNull(message = "操作人名称不能为空")
    @Size(max=32,message = "操作人名称最多输入32个字符")
    @ApiModelProperty("操作人名称")
    private String createName;

    @NotNull(message = "调整货物吨数不能为空")
    @ApiModelProperty("调前煤炭交易数（吨）")
    @DecimalMax(value = "999999999999.99",message = "调整货物吨数不能大于999999999999.99吨")
    private BigDecimal beforeWeight;

    @NotNull(message = "调整货物吨数不能为空")
    @ApiModelProperty("调后煤炭交易数（吨）")
    @DecimalMax(value = "999999999999.99",message = "调整货物吨数不能大于999999999999.99吨")
    private BigDecimal afterWeight;

    @NotNull(message = "已挂单的吨数不能为空")
    @ApiModelProperty("已挂单的吨数（吨）")
    @DecimalMax(value = "999999999999.99",message = "调整货物吨数不能大于999999999999.99吨")
    private BigDecimal orderedWeight;
}
