package com.clx.performance.param.app.collect;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class CollectLineReportAbnormalSaveParam {

    @ApiModelProperty(value = "上报类型：1:无法到达货源地 2:无法装货 3：无法到达目的地  4装车卸车异常", example = "")
    @NotNull(message = "上报类型不能为空")
    private Integer reportType;

    @ApiModelProperty(value = "运单编号")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "无法到达货源地原因", example = "车辆问题")
    @NotBlank(message = "无法到达货源地原因不能为空")
    private String remark;


}
