package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum SettlementOrderChildRiskEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum RiskType {
        SYNC_FAIL(1, "同步失败"),
        SETTLE_FAIL(2, "结算打回");
        private final Integer code;
        private final String msg;

        public static Optional<RiskType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(RiskType::getMsg).orElse(null);
        }
    }



    @Getter
    @AllArgsConstructor
    public enum ProcessMethod {
        SYNC_RETRY(1, "重新同步"),
        CONVERT_ORDINARY(2, "转普通单"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<ProcessMethod> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(ProcessMethod::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum Status {
        INIT(0, "待处理"),
        PROCESSED(1, "已处理");
        private final Integer code;
        private final String msg;

        public static Optional<Status> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Status::getMsg).orElse(null);
        }
    }

}
