package com.clx.performance.service.impl.settle;

import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.enums.settle.SettlementOwnerEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.service.settle.SettlementService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Objects;

@Slf4j
@Service
public class SettlementServiceImpl implements SettlementService {


    @Autowired
    private OrderChildDao orderChildDao;
    @Autowired
    private SettlementOwnerDetailDao settlementOwnerDetailDao;
    @Autowired
    private SettlementDriverDetailDao settlementDriverDetailDao;
    @Autowired
    private SettlementMqService settlementMqService;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSettlementDetailInvoiceType(String childNo, Integer invoiceType) {
        OrderChild orderChild = orderChildDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.ORDER_CHILD_NO_FOUND);
        SettlementOwnerDetail settlementOwnerDetail = settlementOwnerDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        SettlementDriverDetail settlementDriverDetail = settlementDriverDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        if (settlementOwnerDetail.getInvoiceType() != null) {return;}

        // 结算金额<0走普通单
        if (settlementDriverDetail.getSettlementFreight().compareTo(BigDecimal.ZERO) < 0){
            invoiceType = SettlementOwnerEnum.InvoiceType.ORDINARY.getCode();
        }

        settlementOwnerDetail.setInvoiceType(invoiceType);
        settlementDriverDetail.setInvoiceType(invoiceType);

        // 网运单更新预付运费
        if (Objects.equals(settlementOwnerDetail.getInvoiceType(), SettlementOwnerEnum.InvoiceType.ONLINE.getCode())) {
            settlementOwnerDetail.setPrepayFreight(updatePrepayFreightPay(settlementOwnerDetail.getChildNo(),
                    settlementOwnerDetail.getFreight(), settlementOwnerDetail.getLossFreight()));
        }

        settlementOwnerDetailDao.updateInvoiceType(settlementOwnerDetail);
        settlementDriverDetailDao.updateInvoiceType(settlementDriverDetail);

        // 发送mq 通过开票标识
        settlementMqService.invoiceTypeSync(childNo, invoiceType);

    }

    /**
     * 预付运费支付
     */
    private BigDecimal updatePrepayFreightPay(String childNo, BigDecimal freight, BigDecimal lossFreight){
        BigDecimal prepayFreight = freight.subtract(lossFreight);
        if (prepayFreight.compareTo(BigDecimal.ZERO) <= 0) {return BigDecimal.ZERO;}

        //扣减预付运费



        return prepayFreight;

    }
}
