package com.clx.performance.dao.impl;

import com.clx.performance.dao.OrderChildLogDao;
import com.clx.performance.enums.OrderChildLogEnum;
import com.clx.performance.mapper.OrderChildLogMapper;
import com.clx.performance.model.OrderChildLog;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 运单图片
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildLogDaoImpl extends BaseDaoImpl<OrderChildLogMapper, OrderChildLog, Integer> implements OrderChildLogDao {
    @Override
    public List<OrderChildLog> getOrderChildNodeLog(String childNo) {
        return list(lQrWrapper().eq(OrderChildLog::getChildNo,childNo).in(OrderChildLog::getType, OrderChildLogEnum.Type.CREATED.getCode()
                , OrderChildLogEnum.Type.GO_TO_SEND.getCode(), OrderChildLogEnum.Type.ARRIVE_SEND.getCode()
                , OrderChildLogEnum.Type.GO_TO_RECEIVE.getCode(), OrderChildLogEnum.Type.ARRIVE_RECEIVE.getCode()
                , OrderChildLogEnum.Type.LOAD.getCode(), OrderChildLogEnum.Type.UNLOAD.getCode()
                , OrderChildLogEnum.Type.DRIVER_CANCEL.getCode(), OrderChildLogEnum.Type.PLATFORM_CANCEL.getCode()
                , OrderChildLogEnum.Type.OWNER_CANCEL.getCode(), OrderChildLogEnum.Type.DRIVER_CONFIRM.getCode()
                , OrderChildLogEnum.Type.ARTIFICIAL_CANCEL.getCode()).groupBy(OrderChildLog::getType).orderByAsc(OrderChildLog::getId));
    }
}
