package com.clx.performance.controller.app.integral;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.integral.DriverPageIntegralTruckRankParam;
import com.clx.performance.service.IntegralTruckService;
import com.clx.performance.vo.pc.IntegralTruckVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/integral")
@Validated
@Api(tags = "司机APP-积分车辆")
@AllArgsConstructor
public class AppIntegralTruckController {

    private final IntegralTruckService integralTruckService;

    @ApiOperation(value = "获取车辆积分排名", notes = "<br>By:艾庆国")
    @RequestMapping(value = "pageTruckRank", method = RequestMethod.POST)
    public Result<PageData<IntegralTruckVO>> pageTruckRank(@RequestBody @Validated DriverPageIntegralTruckRankParam param) {
        IPage<IntegralTruckVO> page = integralTruckService.driverPageTruckRank(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());

    }

}
