package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.sqlProvider.OrderGoodsSqlProvider;
import com.clx.performance.vo.pc.OrderGoodsVO;
import org.apache.ibatis.annotations.SelectProvider;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsMapper extends BaseMapper<OrderGoods> {

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "getMaxOrderGoodsId")
    Long getMaxOrderGoodsId(String type);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "pageOrderGoodsList")
    IPage<OrderGoodsVO> pageOrderGoodsList(Page<OrderGoodsVO> page, PageOrderGoodsListParam param);
}
