package com.clx.performance.controller.app;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.order.feign.OrderFeign;
import com.clx.order.params.OrderGoodsChildParams;
import com.clx.order.params.OrderGoodsParams;
import com.clx.order.params.PageCarrierOrderListParam;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.order.vo.feign.FeignPageOrderVO;
import com.clx.performance.component.OrderGoodsIdGenerate;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.constant.RedisConstants;
import com.clx.performance.enums.OrderGoodsStatusEnum;
import com.clx.performance.enums.OrderGoodsTypeEnum;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.common.utils.DateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/app/goodsOrder")
@Validated
@Api(tags = "APP-货单")
public class AppGoodsOrderController {

    @Autowired
    OrderGoodsService orderGoodsService;

    @Autowired
    OrderGoodsMapper orderGoodsMapper;


    @ApiOperation(value = "查看货单详情", notes = "<br>By:胡宇帆")
    @GetMapping("/getOrderGoodsInfo")
    @UnitCovert(param = false)
    public Result<OrderGoodsVO> getOrderGoodsInfo(@RequestParam String orderGoodsNo) {
        return Result.ok(orderGoodsService.getOrderGoodsInfoByOrderGoodsNo(orderGoodsNo));
    }

}
