package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.*;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.app.SaveOrderChildVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: aiqingguo
 * @Description: 运单
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/app/driver/orderchild")
@Validated
@Api(tags = "APP-运单")
@AllArgsConstructor
public class AppDriverOrderChildController {

    private final OrderChildService orderChildService;

    @ApiOperation(value = "接单", notes = "<br>By:艾庆国")
    @PostMapping("/saveOrderChild")
    public Result<SaveOrderChildVO> saveOrderChild(@RequestBody @Validated OrderChildSaveParam param) {

        return Result.ok(orderChildService.saveOrderChild(param));
    }

    @ApiOperation(value = "前往货源地", notes = "<br>By:艾庆国")
    @PostMapping("/updateGotoSendAddress")
    public Result<Void> updateGotoSendAddress(@RequestBody @Validated OrderChildGoToSendAddressParam param) {
        orderChildService.updateGotoSendAddress(param);

        return Result.ok();
    }

    @ApiOperation(value = "到达货源地", notes = "<br>By:艾庆国")
    @PostMapping("/updateArriveSendAddress")
    public Result<Void> updateArriveSendAddress(@RequestBody @Validated OrderChildArriveSendAddressParam param) {
        orderChildService.updateArriveSendAddress(param);

        return Result.ok();
    }


    @ApiOperation(value = "前往目的地", notes = "<br>By:艾庆国")
    @PostMapping("/updateGotoReceiveAddress")
    public Result<Void> updateGotoReceiveAddress(@RequestBody @Validated OrderChildGoToReceiveAddressParam param) {
        orderChildService.updateGotoReceiveAddress(param);

        return Result.ok();
    }

    @ApiOperation(value = "到达目的地", notes = "<br>By:艾庆国")
    @PostMapping("/updateArriveReceiveAddress")
    public Result<Void> updateArriveReceiveAddress(@RequestBody @Validated OrderChildArriveReceiveAddressParam param) {
        orderChildService.updateArriveReceiveAddress(param);

        return Result.ok();
    }

    @ApiOperation(value = "装车(首次、重复)", notes = "<br>By:艾庆国")
    @PostMapping("/updateLoad")
    public Result<Void> updateLoad(@RequestBody @Validated OrderChildLoadParam param) {
        orderChildService.updateLoad(param);

        return Result.ok();
    }

    @ApiOperation(value = "卸车(首次、重复)", notes = "<br>By:艾庆国")
    @PostMapping("/updateUnload")
    public Result<Void> updateUnload(@RequestBody @Validated OrderChildUnloadParam param) {
        orderChildService.updateUnload(param);

        return Result.ok();
    }

    @ApiOperation(value = "重新装车卸车", notes = "修改装车卸车信息<br>By:艾庆国")
    @PostMapping("/updateLoadAndUnloadAgain")
    public Result<Void> updateLoadAndUnloadAgain(@RequestBody @Validated OrderChildLoadAndUnloadAgainParam param) {
        orderChildService.updateLoadAndUnloadAgain(param);

        return Result.ok();
    }

    @ApiOperation(value = "确认交货", notes = "<br>By:艾庆国")
    @PostMapping("/updateConfirm")
    public Result<Void> updateDriverConfirm(@RequestBody @Validated OrderChildDriverConfirmParam param) {
        orderChildService.updateDriverConfirm(param);

        return Result.ok();
    }

    @ApiOperation(value = "取消运单", notes = "<br>By:艾庆国")
    @PostMapping("/updateCancel")
    public Result<Void> updateDriverCancel(@RequestBody @Validated OrderChildDriverCancelParam param) {
        orderChildService.updateDriverCancel(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询运单详情", notes = "<br>By:艾庆国")
    @PostMapping("/getOrderChildInfo")
    public Result<OrderChildVO> getOrderChildInfo(String childNo) {

        return Result.ok(orderChildService.getOrderChildInfo(childNo));
    }

    @ApiOperation(value = "分页查询运单列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageOrderChild")
    public Result<PageData<OrderChildVO>> pageOrderChild(@RequestBody PageOrderChildParam param) {
        IPage<OrderChildVO> page = orderChildService.pageOrderChild(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
