package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author xujianke
 * @date 2017年9月14日
 * @description rabbit配置文件
 */
@Configuration
public class RabbitBeanConfig {
    /**
     * 订单已挂单队列
     */
    @Bean
    public Queue orderPostedQueue() {
        return new Queue(RabbitKeyConstants.ORDER_POSTED_QUEUE, true);
    }
    /**
     * 订单已挂单交换机
     **/
    @Bean
    public DirectExchange orderPostedExchange() {
        return new DirectExchange(RabbitKeyConstants.ORDER_POSTED_EXCHANGE);
    }
    /**
     * 订单已挂单绑定
     */
    @Bean
    public Binding orderPostedExchangeBind() {
        return BindingBuilder.bind(orderPostedQueue()).to(orderPostedExchange()).with(RabbitKeyConstants.ORDER_POSTED_ROUTE_KEY);
    }


    @Bean
    public Queue orderOnQueue() {
        Map<String, Object> params = new HashMap<>(6);
        params.put("x-dead-letter-exchange", RabbitKeyConstants.ORDER_ON_DEAD_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyConstants.ORDER_ON_ROUTE_KEY);
        return new Queue(RabbitKeyConstants.ORDER_ON_QUEUE, true, false, false, params);
    }

    /**
     * 订单挂单中交换机
     **/
    @Bean
    public DirectExchange orderOnExchange() {
        return new DirectExchange(RabbitKeyConstants.ORDER_ON_EXCHANGE);
    }

    /**
     * 订单挂单中绑定
     */
    @Bean
    public Binding orderOnExchangeBind() {
        return BindingBuilder.bind(orderOnQueue()).to(orderOnExchange()).with(RabbitKeyConstants.ORDER_ON_ROUTE_KEY);
    }

    /**
     * 死信队列：死信队列处理延迟消息
     * @return
     */
    @Bean
    public Queue orderOnDeadQueue() {
        return new Queue(RabbitKeyConstants.ORDER_ON_DEAD_QUEUE, true, false, false);
    }

    /**
     * 订单挂单中交换机：死信队列处理延迟消息
     **/
    @Bean
    public DirectExchange orderOnDeadExchange() {
        return new DirectExchange(RabbitKeyConstants.ORDER_ON_DEAD_EXCHANGE);
    }

    /**
     * 订单挂单中绑定:死信队列处理延迟消息
     */
    @Bean
    public Binding orderDeadExchangeBind() {
        return BindingBuilder.bind(orderOnDeadQueue()).to(orderOnDeadExchange()).with(RabbitKeyConstants.ORDER_ON_ROUTE_KEY);
    }

}
