package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@NoArgsConstructor
public class OrderChildPoundAuditDetailVO {

    @ApiModelProperty(value="运单编号",example = "41441")
    private String childNo;

    @ApiModelProperty(value="装货净重",example = "10")
    private BigDecimal loadNet;

    @ApiModelProperty(value="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @ApiModelProperty(value="审核状态 0-待审核，1-审核失败， 2-审核成功",example = "1")
    private Integer status;

    @ApiModelProperty(value="备注",example = "41441")
    private String remark;

    @ApiModelProperty(value="审核驳回类型：1装车 2卸车 3装车+卸车",example = "1")
    private Integer rejectType;

    @ApiModelProperty(value="装车磅单图片")
    private List<String> loadImages;

    @ApiModelProperty(value="卸车磅单图片")
    private List<String> unloadImages;



}