package com.clx.performance.vo.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.List;

/**
* @Author: aiqinguo
* @Description: 运单表
* @Date: 2023/09/19 16:49:06
* @Version: 1.0
*/

@ApiModel(description = "运单表")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "")
    private Long userNo;
    @ApiModelProperty(value = "货主用户编号", example = "")
    private Long ownerUserNo;
    @ApiModelProperty(value = "运单编号", example = "")
    private String childNo;
    @ApiModelProperty(value = "货单编号", example = "")
    private String orderGoodsNo;
    @ApiModelProperty(value = "订单编号", example = "")
    private String orderNo;

    @ApiModelProperty(value = "货物id", example = "")
    private Integer goodsId;
    @ApiModelProperty(value = "货物名称", example = "")
    private String goodsName;
    @ApiModelProperty(value = "运费单价（分）", example = "")
    private BigDecimal freightPrice;
    @ApiModelProperty(value = "发货地址id", example = "")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "")
    private String receiveAddress;
    @ApiModelProperty(value = "最晚装货时间", example = "")
    private String loadDeadline;

    @ApiModelProperty(value = "车辆ID", example = "")
    private Integer truckId;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
    @ApiModelProperty(value = "载重（单位吨）", example = "")
    private BigDecimal truckLoad;
    @ApiModelProperty(value = "司机用户编号", example = "")
    private Long driverUserNo;
    @ApiModelProperty(value = "司机姓名", example = "")
    private String driverName;
    @ApiModelProperty(value = "司机手机号", example = "")
    private String driverMobile;

    @ApiModelProperty(value = "装货毛重（单位吨）", example = "")
    private BigDecimal loadRough;
    @ApiModelProperty(value = "装货皮重（单位吨）", example = "")
    private BigDecimal loadTare;
    @ApiModelProperty(value = "装货净重（单位吨）", example = "")
    private BigDecimal loadNet;
    @ApiModelProperty(value = "卸货毛重（单位吨）", example = "")
    private BigDecimal unloadRough;
    @ApiModelProperty(value = "卸货皮重（单位吨）", example = "")
    private BigDecimal unloadTare;
    @ApiModelProperty(value = "卸货净重（单位吨）", example = "")
    private BigDecimal unloadNet;
    @ApiModelProperty(value = "拉运重量（单位吨）", example = "")
    private BigDecimal weight;

    @ApiModelProperty(value = "磅单审核状态", example = "")
    private Integer poundStatus;
    @ApiModelProperty(value = "状态", example = "")
    private Integer status;
    @ApiModelProperty(value = "支付时间", example = "")
    private String payTime;
    @ApiModelProperty(value = "装车时间", example = "")
    private String loadTime;
    @ApiModelProperty(value = "卸车时间", example = "")
    private String unloadTime;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

    @ApiModelProperty(value = "装车磅单图片列表")
    private List<String> loadImageList;

    @ApiModelProperty(value = "卸车磅单图片列表")
    private List<String> unloadImageList;

}