package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderChildLogEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        CREATED(1, "接单成功"),

        GO_TO_SEND(21, "前往货源地"),
        ARRIVE_SEND(22, "到达货源地"),
        GO_TO_RECEIVE(23, "前往目的地"),
        ARRIVE_RECEIVE(24 , "到达目的地"),

        LOAD(31, "提交装货信息"),
        UNLOAD(32, "提交卸货信息"),
        RELOAD(33, "修改装货信息"),
        REUNLOAD(34, "修改卸货信息"),
        RELOAD_AND_REUNLOAD(35, "修改装货、卸货信息"),

        DRIVER_CONFIRM(41, "司机确认收货"),

        COMPLETE(100, "完成"),

        DRIVER_CANCEL(110, "司机取消运单"),
        OWNER_CANCEL(111, "货主取消运单"),

        ;

        private final int code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

    @Getter
    @AllArgsConstructor
    public enum CreateType {
        OWNER(1, "货主"),
        PLATFORM(2, "承运"),
        DRIVER(3, "司机"),

        ;

        private final int code;
        private final String msg;

        public static Optional<CreateType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> e.code == code).findFirst();
        }
    }

}
