package com.clx.performance.sqlProvider.settle;

import cn.hutool.core.util.ObjectUtil;
import com.clx.performance.enums.NetworkDriverAccountEnum;
import com.clx.performance.param.app.NetworkDriverPageParam;
import com.clx.performance.param.pc.PageNetworkAccountInfoListParam;
import com.clx.performance.param.pc.PageNetworkAccountListParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

public class NetworkDriverRunningWaterRecordProvider {

    public String networkDriverRunningWaterRecordDao(@Param("param") PageNetworkAccountInfoListParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.running_water_no," +
                    " a.driver_user_no,a.driver_user_name, a.mobile,a.running_water_type,a.running_water_type_msg,a.fund_type_msg,a.account_balance, " +
                    " a.fund_type,a.order_no,a.order_goods_no,a.child_no,a.alteration_balance," +
                    "a.usable_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("network_driver_running_water_record a");

            if (StringUtils.isNotBlank(param.getDriverUserNo())) {
                WHERE("a.driver_user_no = #{param.driverUserNo}");
            }
            if (StringUtils.isNotBlank(param.getMobile())) {
                WHERE("a.mobile = #{param.mobile}");
            }
            if (ObjectUtil.isNotNull(param.getRunningWaterType())) {
                WHERE("a.running_water_type = #{param.runningWaterType}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

    public String pageFrozenList(@Param("param") NetworkDriverPageParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.running_water_no," +
                    " a.driver_user_no,a.driver_user_name, a.mobile,a.running_water_type,a.running_water_type_msg,a.fund_type_msg, a.account_balance,a.frozen_flag, " +
                    " a.fund_type,a.order_no,a.order_goods_no,a.child_no,a.alteration_balance," +
                    "a.usable_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("network_driver_running_water_record a");

            WHERE("a.driver_user_no = #{param.userNo}");
            WHERE("a.running_water_type = " + NetworkDriverAccountEnum.RunningWaterStatus.CASE_OUT_FROZEN.getCode());
            WHERE("a.frozen_flag != 1");

            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }

    public String runningWaterList(@Param("param") NetworkDriverPageParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.running_water_no," +
                    " a.driver_user_no,a.driver_user_name, a.mobile,a.running_water_type,a.running_water_type_msg,a.fund_type_msg,a.account_balance, " +
                    " a.fund_type,a.order_no,a.order_goods_no,a.child_no,a.alteration_balance," +
                    "a.usable_balance,a.frozen_balance,a.create_by,date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time");
            FROM("network_driver_running_water_record a");
            if (ObjectUtil.isNotNull(param.getUserNo())) {
                WHERE("a.driver_user_no = #{param.userNo}");
            }
            if (ObjectUtil.isNotNull(param.getFundType())) {
                WHERE("a.fund_type = #{param.fundType}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }
}
