package com.clx.performance.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.clx.performance.component.ThirdComponent;
import com.clx.performance.dao.settle.OrderChildSyncTransportRecordDao;
import com.clx.performance.dto.OrderChildSyncDTO;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.model.settle.OrderChildSyncTransportRecord;
import com.clx.performance.param.feign.transport.OrderChildPaySyncParam;
import com.msl.common.dto.HttpDTO;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@Component
@AllArgsConstructor
public class OrderChildPaySyncTransportJob {

    private final OrderChildSyncTransportRecordDao orderChildSyncTransportRecordDao;

    private final TransportFeignService transportFeignService;

    /**
     * 同步网络货运
     */
    @XxlJob("orderChildPaySyncTransportJob")
    public void orderChildPaySyncTransportJob() {
        List<OrderChildSyncTransportRecord> recordList  = orderChildSyncTransportRecordDao.selectListForJob();
        if (CollectionUtil.isEmpty(recordList)) {
            return;
        }

        List<String> orderChilList = recordList.stream().map(OrderChildSyncTransportRecord::getChildNo).collect(Collectors.toList());
        OrderChildPaySyncParam param = new OrderChildPaySyncParam();
        param.setChildNoList(orderChilList);
        HttpDTO httpDTO = transportFeignService.orderChildPaySync(param);
        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
        OrderChildSyncDTO bean = JSONUtil.toBean(decrypt, OrderChildSyncDTO.class);
        if (bean.getCode() == 0) {
            for (OrderChildSyncTransportRecord record : recordList) {
                OrderChildSyncTransportRecord update = new OrderChildSyncTransportRecord();
                update.setId(record.getId());
                update.setStatus(1);
                orderChildSyncTransportRecordDao.updateEntityByKey(update);
            }
        }

    }
}
