package com.clx.performance.dao.impl.vehiclewarn;

import com.clx.performance.dao.vehiclewarn.VehicleWarnRangeDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnRangEnum;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnRangMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnRang;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

@Repository
public class VehicleWarnRangeDaoImpl extends BaseDaoImpl<VehicleWarnRangMapper, VehicleWarnRang, Integer> implements VehicleWarnRangeDao {


    @Override
    public List<VehicleWarnRang> ListByWarnConfigId(Integer warnConfigId) {
        return list(lQrWrapper()
                        .eq(VehicleWarnRang::getWarnConfigId, warnConfigId)
                        .eq(VehicleWarnRang::getStatus, VehicleWarnRangEnum.Status.ENABLE.getCode())
                        .le(VehicleWarnRang::getWarnEndTime, LocalDateTime.now())
                        .orderByDesc(VehicleWarnRang::getId)
                );
    }
}
