package com.clx.performance.dao.impl.vehiclewarn;

import com.clx.performance.dao.vehiclewarn.VehicleWarnChildDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnChildEnum;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnChildMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnChild;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class VehicleWarnChildDaoImpl extends BaseDaoImpl<VehicleWarnChildMapper, VehicleWarnChild, Integer> implements VehicleWarnChildDao {


    @Override
    public boolean updateTraceTime(VehicleWarnChild item) {
        return update(lUdWrapper()
                .eq(VehicleWarnChild::getId, item.getId())
                .set(VehicleWarnChild::getTraceStatus, item.getTraceStatus())
                .set(VehicleWarnChild::getTraceTime, item.getTraceTime())
        );
    }

    @Override
    public boolean updateReceiveAddressDistance(VehicleWarnChild item) {
        return update(lUdWrapper()
                .eq(VehicleWarnChild::getId, item.getId())
                .set(VehicleWarnChild::getReceiveAddressDistance, item.getReceiveAddressDistance())
        );
    }

    @Override
    public Optional<VehicleWarnChild> findByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper().eq(VehicleWarnChild::getChildNo, item))
                .map(super::getOne);
    }

    @Override
    public List<VehicleWarnChild> ListTruckNoOfTrace() {
        return list(lQrWrapper().select(VehicleWarnChild::getChildNo, VehicleWarnChild::getTruckNo).eq(VehicleWarnChild::getTraceStatus, VehicleWarnChildEnum.TraceStatus.ENABLE.getCode()));
    }

    @Override
    public List<VehicleWarnChild> ListTruckNoOfWarn() {
        return list(lQrWrapper().select(VehicleWarnChild::getChildNo, VehicleWarnChild::getTruckNo).eq(VehicleWarnChild::getTraceStatus, VehicleWarnChildEnum.WarnStatus.ENABLE.getCode()));

    }
}
