package com.clx.performance.service.impl.trace;

import com.clx.performance.dto.zjxl.TruckTraceDTO;
import com.clx.performance.esplus.mapper.TruckTraceESPlusMapper;
import com.clx.performance.esplus.model.TruckTraceESPlus;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.vehiclewarn.VehicleWarnChildDao;
import com.clx.performance.dto.zjxl.TruckTraceDTO;
import com.clx.performance.esplus.mapper.TruckTraceESPlusMapper;
import com.clx.performance.esplus.model.TruckTraceESPlus;
import com.clx.performance.param.mq.trace.TruckTraceSyncMqParam;
import com.clx.performance.service.trace.TruckTraceMqHandlerService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.utils.zjxl.ZjxlGpsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class TruckTraceMqHandlerServiceImpl implements TruckTraceMqHandlerService {
    @Autowired
    private ZjxlGpsService zjxlGpsService;

    @Autowired
    private VehicleWarnChildDao vehicleWarnChildDao;
    @Autowired
    private OrderChildDao orderChildDao;

    @Autowired
    private TruckTraceESPlusMapper truckTraceESPlusMapper;


    @Transactional(rollbackFor = Exception.class)
    @Override
    public void truckTracSync(TruckTraceSyncMqParam mq) {

        List<TruckTraceDTO> list = zjxlGpsService.getTruckTrace(mq.getTruckNo(), mq.getBeginTime(), mq.getEndTime());
        if (list.isEmpty()) {return;}

        List<TruckTraceESPlus> esList = new ArrayList<>();
        for (TruckTraceDTO item : list) {
            TruckTraceESPlus es = new TruckTraceESPlus();
            es.setTruckNo(mq.getTruckNo());
            es.setAngle(item.getAngle());
            es.setHeight(item.getHeight());
            es.setLocation(new BigDecimal[]{item.getLocation()[0], item.getLocation()[1]});
            es.setGpsTime(item.getGpsTime());
            es.setMileage(item.getMileage());
            es.setSpeed(item.getSpeed());
            es.setCreateTime(LocalDateTimeUtils.formatTime());

            esList.add(es);
        }

        // 保存
        truckTraceESPlusMapper.insertBatch(esList);
    }

}
