package com.clx.performance.service.impl;

import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDao;
import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.enums.PayRemarkEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.param.pc.payment.PayParam;
import com.clx.performance.param.pc.payment.PayPlatformFeeParam;
import com.clx.performance.service.PaymentService;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriver;
import com.clx.performance.service.TempService;
import com.clx.performance.service.settle.SettlementService;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.UUID;

@Slf4j
@Service
public class TempServiceImpl implements TempService {

    @Autowired
    private SettlementService settlementService;

    @Autowired
    private BreakContractSettlementDriverDao breakContractSettlementDriverDao;
    @Autowired
    private PaymentService paymentService;
    @Override
    public void updateInvoiceType(String childNo, Integer invoiceType) {

        settlementService.updateSettlementDetailInvoiceType(childNo, invoiceType);

    }

    @Override
    public void updateBreakContractDriverSettlementFinish(String settlementNo) {
        BreakContractSettlementDriver settlement = breakContractSettlementDriverDao.selectBySettlementNo(settlementNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        settlement.setSettleStatus(BreakContractSettlementDriverEnum.SettleStatus.YES.getCode());
    }

    @Override
    public void paymentTest(String fromUser, String pwd, String tradeNo,int type) {
//        PayParam noCheckPwd = PayParam.builder().from(
//                Integer.valueOf(fromUser))
//                .to(Integer.valueOf(toUser))
//                .figure(Integer.valueOf(figure))
//                .tradeNo(UUID.randomUUID().toString().replaceAll("-", ""))
//                .tradeId("12345")
//                .pwd("noCheckPwd")
//                .remark(PayRemarkEnum.toString(PayRemarkEnum.FREIGHT_TO_OWNER.getValue()))
//                .build();
//
//
//        paymentService.paymentWallet(noCheckPwd);

        PayPlatformFeeParam payPlatformFeeParam  =  new PayPlatformFeeParam();
        payPlatformFeeParam.setFigure(100);
        payPlatformFeeParam.setFrom(Integer.valueOf(fromUser));
        payPlatformFeeParam.setPwd(pwd);
        payPlatformFeeParam.setTradeNo(tradeNo);

        if(Objects.equals(type,1)){
            paymentService.paymentPlatformFee(payPlatformFeeParam);
        }
        if(Objects.equals(type,2)){
            paymentService.paymentChangePlatformFee(payPlatformFeeParam);
        }
        if(Objects.equals(type,3)){
            paymentService.paymentCompletePlatformFee(payPlatformFeeParam);
        }
        if(Objects.equals(type,4)){
            paymentService.paymentCancelPlatformFee(payPlatformFeeParam);
        }
    }

}
