package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 车辆位置;
 *
 * @author : jiangwenye
 * @date : 2024-05-29
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("truck_position")
public class TruckPosition implements HasKey<Integer> {
    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 车牌号
     */
    @TableField("truck_no")
    private String truckNo;
    /**
     * 运单编号
     */
    @TableField("child_no")
    private String childNo;
    /**
     * 运单状态
     */
    @TableField("child_status")
    private Integer childStatus;;
    /**
     * 运单目的地所在省份
     */
    @TableField("child_province")
    private String childProvince;
    /**
     * 车辆位置所在省份
     */
    @TableField("truck_province")
    private String truckProvince;
    /**
     * 经度
     */
    @TableField("longitude")
    private BigDecimal longitude;
    /**
     * 纬度
     */
    @TableField("latitude")
    private BigDecimal latitude;
    /**
     * 删除状态: 0-否;1-是
     */
    @TableField("delete_status")
    private Integer deleteStatus;
    /**
     * 创建时间
     */
    @TableField("create_time")
    private LocalDateTime createTime;

    @TableField("modified_time")
    private LocalDateTime modifiedTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}
