package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 平台服务费配置表
 *
 * @author yangqifa
 */
@Setter
@Getter
public class PlatformServiceFeeConfig implements HasKey<Integer> {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 订单报价方式,0:未税,1:含税
     */
    private Integer orderQuotationType;

    /**
     * 接单保证金，最多保留两位小数
     */
    private BigDecimal deposit;

    /**
     * 平台服务费费率
     */
    private BigDecimal serviceFeeRate;

    /**
     * 创建时间
     */
    private Date createdTime;

    /**
     * 更新时间
     */
    private Date modifiedTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}