package com.clx.performance.extranal.user.impl;

import com.clx.performance.extranal.user.TruckUserService;
import com.clx.user.feign.TruckFeign;
import com.clx.user.vo.feign.TruckInfoFeignVo;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
@AllArgsConstructor
public class TruckUserServiceImpl implements TruckUserService {
    private final TruckFeign truckFeign;

    @Override
    public Optional<TruckInfoFeignVo> getTruckInfo(Integer truckId) {
        return Optional.ofNullable(truckFeign.getTruckInfo(truckId))
                .filter(Result::succeed)
                .map(Result::getData);
    }

}
