package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum HttpEnum {

    PERFORMANCE_PAY_CLX_PAYMENT(10000, "履约服务向老马上来发起钱包转账",
            "/payment-service/performance/payUserWalletTransfer"),

    PERFORMANCE_PAY_CLX_DRIVER_FREEZE(10000, "履约服务向老马上来发起司机押金冻结",
            "/payment-service/performance/freezeUserMQ"),

    PERFORMANCE_PAY_CLX_ADJUST_DRIVER_FREEZE(10000, "履约服务向老马上来发起司机押金冻结调整",
            "/payment-service/performance/completeFreezeBatchMQ"),
    ;

    private final int code;
    private final String mark;
    private final String url;

    public static HttpEnum getMsg(int code) {
        for (HttpEnum httpEnum : HttpEnum.values()) {
            if (httpEnum.getCode() == code) {
                return httpEnum;
            }
        }
        return null;
    }
}
