package com.clx.performance.dao.payment;

import com.clx.performance.mapper.payment.OrderPaymentMapper;
import com.clx.performance.model.payment.OrderPayment;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

/**
 * @author huningning
 * Date 2024-06-18
 * Time 14:01
 */
public interface OrderPaymentDao extends BaseDao<OrderPaymentMapper, OrderPayment, Integer> {

    Optional<OrderPayment> selectByOrderNoAndItemId(@Param("orderNo")String orderNo,
                                                    @Param("paymentItem")String paymentItem);

    Optional<OrderPayment> selectByRelationNo(@Param("relationNo")String relationNo,
                                              @Param("operation")Integer operation,
                                              @Param("paymentItem")String paymentItem);

    Optional<OrderPayment> selectByOrderNoAndItemIdAndOperation(@Param("orderNo")String orderNo,
                                                    @Param("paymentItem")String paymentItem,
                                                                @Param("operation")Integer operation);

}
