package com.clx.performance.dao.impl.payment;

import com.clx.performance.dao.payment.OrderPaymentDao;
import com.clx.performance.mapper.payment.OrderPaymentMapper;
import com.clx.performance.model.IntegralStatistics;
import com.clx.performance.model.payment.OrderPayment;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

/**
 * @author huningning
 * Date 2024-06-18
 * Time 14:01
 */
@Repository
public class OrderPaymentDaoImpl extends BaseDaoImpl<OrderPaymentMapper, OrderPayment, Integer> implements OrderPaymentDao {
    @Override
    public Optional<OrderPayment> selectByOrderNoAndItemId(String orderNo, String paymentItem) {
        return Optional.of(orderNo)
                .map(item -> lQrWrapper()
                        .eq(OrderPayment::getOrderNo, item)
                        .eq(OrderPayment::getPaymentItem, paymentItem)
                )
                .map(super::getOne);
    }

    @Override
    public Optional<OrderPayment> selectByRelationNo(String relationNo, Integer operation, String paymentItem) {
        return Optional.of(relationNo)
                .map(item -> lQrWrapper()
                        .eq(OrderPayment::getRelationNo, item)
                        .eq(OrderPayment::getOperation, operation)
                        .eq(OrderPayment::getPaymentItem, paymentItem)
                )
                .map(super::getOne);
    }

    @Override
    public Optional<OrderPayment> selectByOrderNoAndItemIdAndOperation(String orderNo, String paymentItem,
                                                                       Integer operation) {
        return Optional.of(orderNo)
                .map(item -> lQrWrapper()
                        .eq(OrderPayment::getOrderNo, item)
                        .eq(OrderPayment::getPaymentItem, paymentItem)
                        .eq(OrderPayment::getOperation, operation)
                )
                .map(super::getOne);
    }


}
