package com.clx.performance.service.customer.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.customer.CustomerComplaintTypeDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.customer.CustomerComplaintType;
import com.clx.performance.param.pc.customer.PageCustomerComplaintTypeParam;
import com.clx.performance.param.pc.customer.SaveComplaintTypeParam;
import com.clx.performance.service.customer.CustomerComplaintTypeService;
import com.clx.performance.struct.customer.CustomerComplaintTypeStruct;
import com.clx.performance.vo.pc.customer.CustomerComplaintTypeVO;
import com.msl.common.exception.ServiceSystemException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @ClassName CustomerComplaintTypeServiceImpl
 * @Description
 * @Author kavin
 * @Date 2023/12/7 10:51
 * @Version 1.0
 */
@Slf4j
@Service
@AllArgsConstructor
public class CustomerComplaintTypeServiceImpl implements CustomerComplaintTypeService {

    private final CustomerComplaintTypeDao customerComplaintTypeDao;
    private final CustomerComplaintTypeStruct customerComplaintTypeStruct;
    @Override
    public void saveCustomerComplaintType(SaveComplaintTypeParam param) {

        long count = customerComplaintTypeDao.countByNameExcludeSelf(param.getName(),param.getId());
        if(count > 0 ){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND,"分类名称重复");
        }
        if(Objects.isNull(param.getId())){  // 新增
            CustomerComplaintType insert = new CustomerComplaintType();
            insert.setName(param.getName());
            customerComplaintTypeDao.saveEntity(insert);
        }else{    //更新
            CustomerComplaintType update = new CustomerComplaintType();
            update.setId(param.getId());
            update.setName(param.getName());
            customerComplaintTypeDao.updateEntityByKey(update);
        }
    }

    @Override
    public Page<CustomerComplaintTypeVO> pageCustomerComplaintType(PageCustomerComplaintTypeParam param) {
        Page<CustomerComplaintType> page =  customerComplaintTypeDao.pageCustomerComplaintType(param);
        return customerComplaintTypeStruct.convertPage(page);
    }

    @Override
    public List<CustomerComplaintTypeVO> getCustomerComplaintTypeSelect(PageCustomerComplaintTypeParam param) {
        List<CustomerComplaintType> list =  customerComplaintTypeDao.getCustomerComplaintTypeSelect(param);
        return customerComplaintTypeStruct.convertList(list);
    }
}
