package com.clx.performance.dao;

import com.clx.performance.mapper.OrderGoodsTruckBindMapper;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * @Author: huyufan
 * @Description: 货单定向绑定车辆表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
public interface OrderGoodsTruckBindDao extends BaseDao<OrderGoodsTruckBindMapper, OrderGoodsTruckBind, Integer> {

    void saveBatchEntity(String orderNo, String orderGoodsNo, List<String> trackList, LocalDateTime now);

    boolean updateStatus(OrderGoodsTruckBind item);


    List<Integer> getTrucksByOrderGoodsNo(String orderGoodsNo);
    Optional<OrderGoodsTruckBind> getByOrderGoodsNoAndTruckNo(String orderGoodsNo, String truckNo);
    Optional<OrderGoodsTruckBind> getValidByOrderGoodsNoAndTruckNo(String truckNo);
    Optional<List<OrderGoodsTruckBind>> getValidByTruckNo(String truckNo);

    Optional<List<OrderGoodsTruckBind>> selectListByTruckNo(List<String> truckList);

    void updateOrderGoodsBindStatus(String orderGoodsNo, Integer code);

    void updateOrderGoodsBindStatus(String orderGoodsNo, Integer code, List<String> truckList);

    void updateOrderGoodsBindStatus(String orderGoodsNo, Integer code, String truckNo);

    void updateAllOrderGoodsBindStatus(String orderGoodsNo, Integer code, String truckNo);


    List<OrderGoodsTruckBind> selectListByOrderGoodsNo(String orderGoodsNo);

    void updateOrderGoodsBindStatusExpire(String orderGoodsNo, String truckNo);


    List<OrderGoodsTruckBind> getTrucksBindByOrderGoodsNo(String orderGoodsNo,String truckNo);

    List<OrderGoodsTruckBind>  judgeTruckIsBindDxOrder(Set<String> set);

    void deleteByIds(List<Integer> ids);

    List<OrderGoodsTruckBind> selectCancelRecord(String orderGoodsNo, List<String> truckList);

    List<OrderGoodsTruckBind> getCancelOrderGoods(List<String> truckList, String beginTime, String endTime);

    void deleteByOrderGoods(String orderGoodsNo);

    List<String> findUnreleasedTruck();


    void updateTruckBindExpire(List<Integer> ids);
}
