package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author jiangwj
 * Date 2024-08-07
 * Time 16:29
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_operate_limit_config")
public class OrderChildOperateLimitConfig implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("name")
    @ApiModelProperty("配置名称")
    private String name;

    @TableField("allow_upload_distance")
    @ApiModelProperty("可上传装车信息范围")
    private BigDecimal allowUploadDistance;

    @TableField("status")
    @ApiModelProperty("启用状态0禁用，1启用")
    private Integer status;

    @TableField("created_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createdTime;

    @TableField("modified_time")
    @ApiModelProperty("更新时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
