package com.clx.performance.vo.pc;

import com.clx.performance.enums.OrderGoodsEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;


@Getter
@Setter
@NoArgsConstructor
public class OrderGoodsVO {

    @ApiModelProperty("货单id")
    private Integer id;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @ApiModelProperty("货单状态")
    private Integer orderGoodsStatus;

    @ApiModelProperty("提取吨数")
    private BigDecimal extractWeight;

    @ApiModelProperty("剩余拉运吨数")
    private BigDecimal residueTransportWeight;

    @ApiModelProperty("已拉运吨数")
    private BigDecimal alreadyTransportWeight;

    @ApiModelProperty("已装车吨数")
    private BigDecimal alreadyLoadWeight;

    @ApiModelProperty("发货地址ID")
    private Integer sendAddressId;

    @ApiModelProperty(value = "发货地址全称")
    private String sendAddressAll;

    @ApiModelProperty("发货地址简称")
    private String sendAddressShorter;

    @ApiModelProperty("发货地址经度")
    private BigDecimal sendLongitude;

    @ApiModelProperty("发货地址纬度")
    private BigDecimal sendLatitude;

    @ApiModelProperty("收货地址ID")
    private Integer receiveAddressId;

    @ApiModelProperty(value="收货地址全称")
    private String reveiveAddressAll;

    @ApiModelProperty("收货地址简称")
    private String receiveAddressShorter;

    @ApiModelProperty("收货地址经度")
    private BigDecimal receiveLongitude;

    @ApiModelProperty("收货地址纬度")
    private BigDecimal receiveLatitude;

    @ApiModelProperty("货物ID")
    private Integer goodsId;

    @ApiModelProperty("货物名称")
    private String goodsName;

    @ApiModelProperty("挂单方式  1公开派单  2定向派单  3车队公开派单  4车队定向派单")
    private Integer pendingOrderWay;

    @ApiModelProperty("定向运单失效时间")
    private String directionalExpireTime;

    @ApiModelProperty("最晚到达货源地时间/运单的最晚装货时间")
    private String lastArriveSendTime;

    @ApiModelProperty("挂单时间")
    private String pendingOrderTime;

    @ApiModelProperty("提取方式 1提取全部 2提取部分")
    private Integer extractWay;

    @ApiModelProperty("需要车辆/辆")
    private Integer needTruckNum;

    @ApiModelProperty("高级物流经理id")
    private Integer seniorLogisticsManagerId;

    @ApiModelProperty("高级物流经理姓名")
    private String seniorLogisticsManagerName;

    @ApiModelProperty("挂单运费")
    @MoneyOutConvert
    private BigDecimal pendingOrderFreight;

    @ApiModelProperty("创建人用户编号")
    private Long userNo;

    @ApiModelProperty("创建人姓名")
    private String userName;

    @ApiModelProperty("创建时间")
    private String createTime;

    @ApiModelProperty("车辆列表")
    private List<String> truckList;

    @ApiModelProperty("批次号")
    private String batchNumber;

    @ApiModelProperty("'最晚到达目的地时间'")
    private String lastArriveReceiveTime;

    @ApiModelProperty("最晚装货时间")
    private String lastLoadTime;

    @ApiModelProperty("'最晚接单时间'")
    private String lastOrderTime;

    @ApiModelProperty("是否暂停 0：否   1：是")
    private Integer stopFlag;
    @ApiModelProperty("结算账期  1拉运完成结  2月结")
    private Integer settlementAccountPeriod;

    @ApiModelProperty("用车方式 1：平台车辆配货 2：自有车辆配货")
    private Integer vehicleUsage;

    @ApiModelProperty("可卸车时间段开始")
    private String unloadBeginTime;

    @ApiModelProperty("可卸车时间段结束")
    private String unloadEndTime;

    @ApiModelProperty("可装车时间段开始")
    private String loadBeginTime;

    @ApiModelProperty("可装车时间段结束")
    private String loadEndTime;

    @ApiModelProperty("平台运费报价税类型：0未税 1含税")
    private Integer platformFreightQuotationTaxType;

    @ApiModelProperty("平台服务费费率%")
    private BigDecimal platformServiceFeeRate;

    @MoneyOutConvert
    @ApiModelProperty("接单保证金（分/车）")
    private BigDecimal deposit;

    @ApiModelProperty("是否支持借款：0:否 1:是")
    private Integer supportLoan;


    @ApiModelProperty("结算方式  1装车净重 2卸车净重")
    private Integer settlementWay;

    @ApiModelProperty("接单保证金 平台服务费费率 弹窗和文案显示 0 不显示  1 显示")
    private Integer goodsOrderDetailShow =  0;

    @ApiModelProperty("已派单数")
    private Integer dispatchedOrders;

    /* 20240730 增加货源地信息 */

    @ApiModelProperty(value = "货源地现场联系人")
    private String sendContact;

    @ApiModelProperty(value = "货源地联系人手机号")
    private String sendContactPhone;

    @ApiModelProperty(value = "发货-是否需要系统排队 0 否  1 是")
    private Integer sendWaitSystem;

    @ApiModelProperty(value = "发货-是否需要系统排队 描述：  需要 不需要")
    public String getSendWaitSystemMsg() {
        return OrderGoodsEnum.SendWaitSystemMsgEnum.getMsgByCode(sendWaitSystem);
    }

    @ApiModelProperty(value = "发货-排队系统名称")
    private String sendWaitSystemName;

    @ApiModelProperty(value = "发货-排队系统形式  1:小程序  2:app")
    private Integer sendWaitMode;

    @ApiModelProperty(value = "发货-排队系统形式 描述：  微信小程序  app")
    public String getSendWaitModeMsg() {
        return OrderGoodsEnum.SendWaitModeEnum.getMsgByCode(sendWaitMode);
    }


    @ApiModelProperty("当前货单总吨数是否超过总拉运量  1:超过  ")
    private Integer overOrderWeight;

    @ApiModelProperty(value = "目的地现场联系人")
    private String receiveContact;

    @ApiModelProperty(value = "目的地联系人手机号")
    private String receiveContactPhone;

    @ApiModelProperty(value = "收货-是否需要系统排队 0 否  1 是")
    private Integer receiveWaitSystem;

    @ApiModelProperty(value = "收货-是否需要系统排队 描述：  需要 不需要")
    public String getReceiveWaitSystemMsg() {
        return OrderGoodsEnum.SendWaitSystemMsgEnum.getMsgByCode(receiveWaitSystem);
    }

    @ApiModelProperty(value = "收货-排队系统名称")
    private String receiveWaitSystemName;

    @ApiModelProperty(value = "收货-排队系统形式  1:小程序  2:app")
    private Integer receiveWaitMode;

    @ApiModelProperty(value = "收货-排队系统形式 描述：  微信小程序  app")
    public String getReceiveWaitModeMsg() {
        return OrderGoodsEnum.SendWaitModeEnum.getMsgByCode(receiveWaitMode);
    }
}